<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $related_products ) : ?>

	<div class="related products">

		<div class="shortcode-title">
	        <h2><?php esc_html_e( 'Related Products', 'automatic' ); ?></h2>
	    </div>

		<div class="automatic-product-related  automatic-product-trendding initSlide_product" data-columns="3" data-column992="2" data-column768="1">
			<div class="beans-stepslider" data-rotate="true">
	            <div class="beans-mask">
	                <div class="beans-slideset">

					<?php foreach ( $related_products as $related_product ) : ?>

						<?php
							$post_object = get_post( $related_product->get_id() );

							setup_postdata( $GLOBALS['post'] =& $post_object );

							wc_get_template_part( 'content', 'product-related' ); ?>

					<?php endforeach; ?>

		
					</div>
				</div>
				<a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
			</div>
		</div>
	</div>

<?php endif;

wp_reset_postdata();
